<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Login extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
	}

	public function index()
	{ 

		if ($this->Employee->is_logged_in()) {
			redirect('home');
		} else {
			$this->form_validation->set_rules('username', 'lang:login_undername', 'callback_login_check');
			$this->form_validation->set_error_delimiters('<div class="error">', '</div>');

			if ($this->form_validation->run() == FALSE) {
				$this->load->view('login');
			} else {
				$this->load->model('Stock_location');
				$this->Stock_location->get_updated_locations();
				if ($this->config->item('statistics')) {
					$this->load->library('tracking_lib');

					$this->tracking_lib->track_page('login', 'login');

					$this->tracking_lib->track_event('Stats', 'Theme', $this->config->item('theme'));
					$this->tracking_lib->track_event('Stats', 'Language', $this->config->item('language'));
					$this->tracking_lib->track_event('Stats', 'Timezone', $this->config->item('timezone'));
					$this->tracking_lib->track_event('Stats', 'Currency', $this->config->item('currency_symbol'));
					$this->tracking_lib->track_event('Stats', 'Customer Sales Tax Support', $this->config->item('customer_sales_tax_support'));
					$this->tracking_lib->track_event('Stats', 'Tax Included', $this->config->item('tax_included'));
					$this->tracking_lib->track_event('Stats', 'Thousands Separator', $this->config->item('thousands_separator'));
					$this->tracking_lib->track_event('Stats', 'Currency Decimals', $this->config->item('currency_decimals'));
					$this->tracking_lib->track_event('Stats', 'Tax Decimals', $this->config->item('tax_decimals'));
					$this->tracking_lib->track_event('Stats', 'Quantity Decimals', $this->config->item('quantity_decimals'));
					$this->tracking_lib->track_event('Stats', 'Invoice Enable', $this->config->item('invoice_enable'));
					$this->tracking_lib->track_event('Stats', 'Date or Time Format', $this->config->item('date_or_time_format'));
				}

				redirect('home');
			}
		}
	}


	public function post_data()
	{
		header('Content-Type:application/json');
		ini_set('memory_limit', '2048M');
		header('Content-Type: application/json');
		$item_sales = [];
		$transaction_successful_new_transfers = false;


		foreach ($_POST as $k => $v) {
			if ($k == 'new_user_employee') {
				$v = json_decode($v);
				foreach ($v as $a => $b) {
					$phone_number = $b->ipos_people->phone_number;
					if ($phone_number) {
						$user_available = $this->db->where('phone_number', $phone_number)->count_all_results('ipos_people');
						if(!$user_available){
    						$people_data = (array)$b->ipos_people;
    						$this->db->insert('ipos_people', $people_data);
    						$insert_id = $this->db->insert_id();
    						if ($insert_id) {
    							$employee_data = (array)$b->ipos_cust_or_emp;
    							$employee_data['person_id'] = $insert_id;
    							$this->db->insert('ipos_employees', $employee_data);
    						}
						}
					}
				}
			}

			if ($k == 'new_user_customer') {
				$v = json_decode($v);
				foreach ($v as $a => $b) {
					$phone_number = $b->ipos_people->phone_number;
					if ($phone_number) {
						$user_available = $this->db->where('phone_number', $phone_number)->count_all_results('ipos_people');
						if(!$user_available){
    						$people_data = (array)$b->ipos_people;
    						$this->db->insert('ipos_people', $people_data);
    						$insert_id = $this->db->insert_id();
    						if ($insert_id) {
    							$customer_data = (array)$b->ipos_cust_or_emp;
    							$customer_data['person_id'] = $insert_id;
    							$this->db->insert('ipos_customers', $customer_data);
    						}
						}
					}
				}
			}

			if ($k == 'after_status_changed') {
				foreach ($v as $a => $b) {
					$this->db->where(['reference' => $b['reference'], 'employee_id' => $b['employee_id']])->update('ipos_item_transfer', ['status' => $b['status'], 'pushed_after_status_update' => 1]);
				}
			}

			if ($k == 'new_sales') {
				$v = json_decode($v);
				foreach ($v as $a => $b) {
					$sales_data = (array)$b->ipos_sales;
					$sale_type = $sales_data['sales_type'];


                    $phone_no = $b->customer->people->phone_number;
                    $count = $this->db->where('phone_number', $phone_no)->count_all_results('ipos_people');
                    if($count){
                    // if(0){
                        $people = $this->db->where('phone_number', $phone_no)->get('ipos_people')->row_array();
                        $people_person_id = $people['person_id'];
                    }else{
                        $people_data = (array)($b->customer->people);
                        unset($people_data['person_id']);
                        $result = $this->db->insert('ipos_people', $people_data);
                        
                        
                        if (!$result) {
                            $error_message = $this->db->error();
                            echo 'Database Error: ' . $error_message['message'];
                            die();
                        }else{
                            $people_person_id = $this->db->insert_id();
                            $customer_data = (array)($b->customer->customer);
                            $customer_data['person_id'] = $people_person_id;
                            unset($customer_data['sync_status']);
                            $result1 = $this->db->insert('ipos_customers', ($customer_data));
                            if (!$result1) {
                                $error_message = $this->db->error();
                                echo 'Database Error: ' . $error_message['message'];
                                die();
                            }
                        }
                        
                        
            
                        if (!$result) {
                            $error_message = $this->db->error();
                            echo 'Database Error: ' . $error_message['message'];
                            die();
                        }else{
                            $people_person_id = $this->db->insert_id();
                        }
                    }
                    
                    
                    
                    $phone_no1 = $b->employee->people->phone_number;
                    $count1 = $this->db->where('phone_number', $phone_no1)->count_all_results('ipos_people');
                    if($count1){
                    // if(0){
                        $people1 = $this->db->where('phone_number', $phone_no1)->get('ipos_people')->row_array();
                        $people_person_id1 = $people1['person_id'];
                    }else{
                        $people_data1 = (array)($b->employee->people);
                        unset($people_data1['person_id']);
                        $result1 = $this->db->insert('ipos_people', $people_data1);
                        if (!$result1) {
                            $error_message = $this->db->error();
                            echo 'Database Error: ' . $error_message['message'];
                            die();
                        }else{
                            $people_person_id1 = $this->db->insert_id();
                            $employee_data = (array)($b->employee->employee);
                            $employee_data['person_id'] = $people_person_id1;
                            unset($employee_data['sync_status']);
                            $result1 = $this->db->insert('ipos_employees', ($employee_data));
                            if (!$result1) {
                                $error_message = $this->db->error();
                                echo 'Database Error: ' . $error_message['message'];
                                die();
                            }
                        }
                    }
                    
                    
            
                    $sales_data['customer_id'] = $people_person_id;
                    $sales_data['employee_id'] = $people_person_id1;
                    
                

					$this->db->insert('ipos_sales', $sales_data);
					$insert_id1 = $this->db->insert_id();
					if ($insert_id1) {
						$sales_data = (array)$b->ipos_sales_items;
						$sold_data = [
							'item_id' => $sales_data['item_id'],
							'quantity_purchased' => $sales_data['quantity_purchased'],
						];
						array_push($item_sales, $sold_data);
						$sales_data['sale_id'] = $insert_id1;
						$this->db->insert('ipos_sales_items', $sales_data);
						if ($sale_type == 1) {
							$return_data = (array)($b->ipos_return);
							$return_data['sale_id_for_this_return'] = $insert_id1;
							unset($return_data['id']);
							$this->db->insert('ipos_sales_returns', $return_data);
						}
					}
				}
			}
			
			if ($k == 'new_transfers') {
				foreach ($v as $a => $b) {
					$item_available = $this->db->where('reference', $b['ipos_item_transfer']['reference'])->get('ipos_item_transfer')->row();
					if ($item_available) {

						$this->db->where('reference', $b['ipos_item_transfer']['reference'])->update('ipos_item_transfer', ['status' => $b['ipos_item_transfer']['status']]);
					} else {

						$b['ipos_item_transfer']['local_to_live_status'] = 1;
						unset($b['ipos_item_transfer']['transfer_id']);
						if (!$this->db->insert('ipos_item_transfer', $b['ipos_item_transfer'])) {
							$error = $this->db->error();
							dd("Error: " . $error['message']);
						}
						$insert_id = $this->db->insert_id();
						if ($insert_id) {
							//foreach multiple ipos_items_push
							foreach ($b['ipos_items_push'] as $item => $value) {

								$this->db->set('quantity', 'quantity - ' . $value['pushed_quantity'], FALSE)
									->where([
										'item_id' => $value['item_id'],
										'location_id' => $value['request_from_branch_id']
									])
									->update('ipos_item_quantities');

								$this->db->set('quantity', 'quantity + ' . $value['pushed_quantity'], FALSE)
									->where([
										'item_id' => $value['item_id'],
										'location_id' => $value['request_to_branch_id']
									])
									->update('ipos_item_quantities');

								$value['transfer_id'] =  $insert_id;
								if ($this->db->insert('ipos_items_push', $value)) {
									$transaction_successful_new_transfers = true;
								} else {


									$transaction_successful_new_transfers = false;
									$error = $this->db->error();
									$this->db->delete('ipos_item_transfer', $insert_id);
									$this->db->delete('ipos_items_push', $insert_id);
									break;
								}
							}
						}
					}
				}
			}
		
			if ($k == 'ipos_people') {
				$v = json_decode($v, true);
			
				$ipos_people = $this->db->get('ipos_people')->result_array();
				foreach ($ipos_people as $f => $g) {
					$ipos_customers = 	$this->db->where('person_id', $g['person_id'])->get('ipos_customers')->row();
					if (!$ipos_customers) {
						$ipos_employees = 	$this->db->where('person_id', $g['person_id'])->get('ipos_employees')->row();
						if ($ipos_employees) {
							$ipos_people[$f]['ipos_employees'] = $ipos_employees;
						}
					} else {
						$ipos_people[$f]['ipos_customers'] = $ipos_customers;
					}
				}
				$not_in_array_2 = array_filter($ipos_people, function ($person) use ($v) {
					foreach ($v as $person2) {
						if ($person['phone_number'] == $person2['phone_number']) {
							return false;
						}
					}
					return true;
				});
				$temp['people_employee_customer_direct_register_on_live'] = $not_in_array_2;
			}
		}

		// subtract quantity after sales of local from live
		foreach ($item_sales as $k => $v) {
			$this->db->set('quantity', 'quantity - ' . ($v['quantity_purchased']), FALSE)
				->set('sync_status', '0')
				->where(['item_id' => $v['item_id'], 'location_id' => $_POST['location_id']])
				->update('ipos_item_quantities');
		}
		
		
		
		// sending data to local
		$temp['ipos_receivings_items'] = $this->db->where(['item_location' => $_POST['location_id'], 'sync_status' => 0])->get('ipos_receivings_items')->result_array();
		$receiving_ids = [0];
		$item_ids = [0];
		foreach ($temp['ipos_receivings_items'] as $item) {
			array_push($receiving_ids, $item['receiving_id']);
			array_push($item_ids, $item['item_id']);
		}

	

		// pull status of transers
		$temp['ipos_item_transfer'] = ($this->db->get('ipos_item_transfer')->result_array());

		// getting new transfers and transfers items
		$ipos_item_transfer = ($this->db->where(['live_to_local_status' => 0, 'request_to_branch_id' => $_POST['location_id']])->get('ipos_item_transfer')->result_array());
		$ipos_items_push = ($this->db->get('ipos_items_push')->result_array());
		
	
	
	
		foreach ($ipos_item_transfer as $i => $j) {
			
			$transfer_data['ipos_items_push'] = null; // Initialize with a default value
			foreach ($ipos_items_push as $item) {
				if ($item['transfer_id'] == $j['transfer_id']) {
					$transfer_data['ipos_items_push'][] = $item;
				}
			}
			if(count($transfer_data['ipos_items_push'])){
			    $transfer_data['ipos_item_transfer'] = $j;
			}

			$temp['new_transfers'][] = $transfer_data;
		}



		$temp['transaction_successful_new_transfer'] = $transaction_successful_new_transfers;
		$temp['ipos_receivings'] = $this->db->where_in('receiving_id', $receiving_ids)->get('ipos_receivings')->result_array();
		$temp['ipos_item_quantities'] = $this->db->where(['sync_status' => 0, 'location_id' => $_POST['location_id']])->get('ipos_item_quantities')->result_array();
		$temp['ipos_stock_locations'] = $this->db->get('ipos_stock_locations')->result_array();;


		
		// update sync status 
		$this->db->where('item_location', $_POST['location_id'])->update('ipos_receivings_items', ['sync_status' => 1]);
		$this->db->where_in('receiving_id', $ids)->update('ipos_receivings', ['sync_status' => 1]);
		$this->db->where('location_id', $_POST['location_id'])->update('ipos_item_quantities', ['sync_status' => 1]);
		$this->db->where(['live_to_local_status' => 0, 'request_to_branch_id' => $_POST['location_id']])->update('ipos_item_transfer', ['live_to_local_status' => 1]);
		$this->db->where(['pulled_after_status_update' => 0, 'request_from_branch_id' => $_POST['location_id']])->update('ipos_item_transfer', ['pulled_after_status_update' => 1]);


		$this->output->set_content_type('application/json')->set_output(json_encode($temp));
	}


	public function login_check($username)
	{
		$password = $this->input->post('password');

		if ($this->_security_check($username, $password)) {
			$this->form_validation->set_message('login_check', 'Security check failure');

			return FALSE;
		}

		if (!$this->Employee->login($username, $password)) {
			$this->form_validation->set_message('login_check', $this->lang->line('login_invalid_username_and_password'));
			return FALSE;
		}
		return TRUE;
	}


	private function _security_check($username, $password)
	{
		return FALSE;
	}
}
